IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_FECOP_PDV_VD]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_FECOP_PDV_VD]
GO
GO
-- VERSAO 3123
--EXEC P_GERA_FECOP_PDV_VD 1,3, '01/04/2016','01/04/2016',0

CREATE PROCEDURE [dbo].[P_GERA_FECOP_PDV_VD] (@CD_EMP INT, 
													   @CD_FILIAL INT, 
													   @DT_INI DATETIME,
													   @DT_FIM DATETIME,
													   @VISUALIZAR INT = 0)  WITH ENCRYPTION  AS 



CREATE TABLE #RsSaidasPdv (
						CD_EMP							INT,
						CD_FILIAL						INT,
						CD_VD							INT,
						CD_IT							INT,
						CD_PROD							INT,
						FECOP_RECALCULADO			    INT,
						PERC_ALIQ_FECOP					MONEY,	
						VLR_FECOP   					MONEY)

--Gerando tabela inicial com o calculo padrao de fundo de combate a pobreza(FECOP)
INSERT INTO #RsSaidasPdv
SELECT
	PDV_VD_IT.CD_EMP,
	PDV_VD_IT.CD_FILIAL,
	PDV_VD_IT.CD_VD,
	PDV_VD_IT.CD_IT,
	PDV_VD_IT.CD_PROD,
	1 AS FECOP_RECALCULADO,
	VINC_NCM.PERC_ALIQ AS PERC_ALIQ_FECOP,
	0 as VLR_FECOP
FROM
	PDV_VD INNER JOIN PDV_VD_IT ON 
	PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP 
	AND PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL
	AND PDV_VD.CD_VD = PDV_VD_IT.CD_VD

	INNER JOIN EST_PROD 
          ON       PDV_VD_IT.CD_EMP  = EST_PROD.CD_EMP
          AND      PDV_VD_IT.CD_PROD = EST_PROD.CD_PROD
          INNER JOIN EST_PROD_NCM_CADASTRO_COMB_POBREZA VINC_NCM
          ON       VINC_NCM.NR_NCM = EST_PROD.NR_NCM
		  INNER JOIN PRC_FILIAL           ON       
		  PDV_VD.CD_EMP    = PRC_FILIAL.CD_EMP
          AND   PDV_VD.CD_FILIAL = PRC_FILIAL.CD_FILIAL
		  INNER JOIN GLB_CID ON 
		  GLB_CID.CD_CID = PRC_FILIAL.CD_CID

WHERE
	PDV_VD_IT.CD_EMP = @CD_EMP 
	AND PDV_VD_IT.CD_FILIAL = @CD_FILIAL 
	AND PDV_VD_IT.DT_VD BETWEEN @DT_INI AND  @DT_FIM
	AND RIGHT(PDV_VD_IT.CD_TRIB_FC,2) in (00,20)
	AND GLB_CID.UF COLLATE SQL_Latin1_General_CP1_CI_AS  = VINC_NCM.UF COLLATE SQL_Latin1_General_CP1_CI_AS
	AND ISNULL(PROD_EXCESSAO_FECOP,0) =0

--Alterando a saida de acordo com o novo calculo criado
IF @VISUALIZAR =0 
begin
	UPDATE
		s
	SET 
		s.PERC_FECOP= snv.PERC_ALIQ_FECOP, 
		s.FECOP_RECALCULADO = 1
	FROM
		#RsSaidasPdv snv INNER JOIN PDV_VD_IT s ON
		snv.CD_EMP = s.CD_EMP AND
		snv.CD_FILIAL = s.CD_FILIAL AND 
		snv.CD_VD = s.CD_VD AND
		snv.CD_PROD = s.CD_PROD AND 
		snv.CD_IT = s.CD_IT 
		
end

IF @VISUALIZAR =1 
begin
--Alterando a saida de acordo com o novo calculo criado
SELECT
*
FROM
	#RsSaidasPdv 
end

DROP TABLE #RsSaidasPdv;
GO
